<?php
require_once "../Api.php";
require "./get/getSettings.php";
require "./put/updateSettings.php";
require "./post/createSettings.php";
require "./patch/changeSettings.php";
require "./delete/deleteSettings.php";

class settingsApi extends Api
{
   public $apiName = "settings";

   /**
    * Метод GET
    * Вывод списка всех записей
    * http://ДОМЕН/Settings
    * @return string
    */
   public function getAction()
   {
      /* $path = getParams();
        if (isset($path)) {
            $key = $path[0];
            $id = count($path) == 2 ? $path[1] : null;
            switch ($key) {
                case 'storage':
                    return getStorageInfo();
                    break;
                case 'disks':
                    return isset($id) ? getDisk($id): getDiskInfo();
                    break;
                default:
                    break;
            }
        } else {
            header('HTTP/1.1 400 Bad Request');
            die();
        } */
   }

   /**
    * Метод POST
    * Создание новой записи
    * http://ДОМЕН/Settings
    * @return string
    */
   public function createAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "restart":
               return restartServer();
               break;
            case "reboot":
               return rebootServer();
               break;
            case "logout":
               return logOut();
               break;
            case "login":
               tryAuth();
               break;
            case "upload":
               return upload();
               break;
            case "load_user_config":
               loadUserConfig();
               break;
            case "save_user_config":
               saveUserConfig();
               break;
            case "save_system_config":
               saveSystemConfig();
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод PATCH
    * Создание новой записи
    * http://ДОМЕН/Settings
    * @return string
    */
   public function changeAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "pass":
               changePass($id);
               break;
            case "ipcams":
               changeIpcams();
               break;
            case "basic":
               return changeBasic();
               break;
            default:
               header("HTTP/1.1 400 Bad Request");
               die();
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод PUT
    * Обновление отдельной записи (по ее id)
    * http://ДОМЕН/Settings
    * @return string
    */
   public function updateAction()
   {
      /*  $path = getParams();
        if (isset($path)) {
            $key = $path[0];
            $id = count($path) == 2 ? $path[1] : null;
            switch ($key) {
                case 'channels':
                    newConnection($id);
                    break;
                default:
                    break;
            }
        } else {
            header('HTTP/1.1 400 Bad Request');
            die();
        } */
   }

   /**
    * Метод DELETE
    * Удаление отдельной записи (по ее id)
    * http://ДОМЕН/Settings
    * @return string
    */
   public function deleteAction()
   {
      /*  $path = getParams();
        if (isset($path)) {
            $key = $path[0];
            $id = count($path) == 2 ? $path[1] : null;
            switch ($key) {
                case 'channels':
                    resetCamera($id);
                    break;
                default:
                    break;
            }
        } else {
            header('HTTP/1.1 400 Bad Request');
            die();
        } */
   }
}
